import java.io.*;
import java.util.*;

public class Main {

    // Fenwick / BIT
    static class Fenwick {
        int n;
        long[] tree;

        Fenwick(int n) {
            this.n = n;
            tree = new long[n + 1];
        }

        void add(int i, long v) {
            while (i <= n) {
                tree[i] += v;
                i += i & -i;
            }
        }

        long sum(int i) {
            long s = 0;
            while (i > 0) {
                s += tree[i];
                i -= i & -i;
            }
            return s;
        }
    }

    public static void main(String[] args) throws Exception {
        FastScanner fs = new FastScanner(System.in);

        int N = fs.nextInt();
        int Q = fs.nextInt();

        int[] a = new int[N + 1];
        for (int i = 1; i <= N; i++) {
            a[i] = fs.nextInt();
        }

        // pozicije svake vrednosti
        ArrayList<TreeSet<Integer>> pos = new ArrayList<>();
        for (int i = 0; i <= N; i++) pos.add(new TreeSet<>());

        for (int i = 1; i <= N; i++) {
            pos.get(a[i]).add(i);
        }

        Fenwick fw = new Fenwick(N);

        // dodaj doprinos vrednosti v
        java.util.function.IntConsumer addValue = (v) -> {
            if (!pos.get(v).isEmpty()) {
                int last = pos.get(v).last();
                fw.add(last, 1L * v * pos.get(v).size());
            }
        };

        // ukloni doprinos vrednosti v
        java.util.function.IntConsumer removeValue = (v) -> {
            if (!pos.get(v).isEmpty()) {
                int last = pos.get(v).last();
                fw.add(last, -1L * v * pos.get(v).size());
            }
        };

        // inicijalno punjenje BIT-a
        for (int v = 1; v <= N; v++) {
            addValue.accept(v);
        }

        StringBuilder out = new StringBuilder();

        while (Q-- > 0) {
            int t = fs.nextInt();

            if (t == 1) {
                int k = fs.nextInt();
                out.append(fw.sum(k)).append('\n');
            } else {
                int x = fs.nextInt();
                int y = fs.nextInt();

                int old = a[x];
                if (old != y) {
                    // ukloni staru vrednost
                    removeValue.accept(old);
                    pos.get(old).remove(x);
                    addValue.accept(old);

                    // dodaj novu vrednost
                    removeValue.accept(y);
                    pos.get(y).add(x);
                    addValue.accept(y);

                    a[x] = y;
                }
            }
        }

        System.out.print(out.toString());
    }

    // Brzi ulaz
    static class FastScanner {
        private final byte[] buffer = new byte[1 << 16];
        private int ptr = 0, len = 0;
        private final InputStream in;

        FastScanner(InputStream in) {
            this.in = in;
        }

        int read() throws IOException {
            if (ptr >= len) {
                len = in.read(buffer);
                ptr = 0;
                if (len <= 0) return -1;
            }
            return buffer[ptr++];
        }

        int nextInt() throws IOException {
            int c;
            while ((c = read()) <= ' ') ;
            int sgn = 1;
            if (c == '-') {
                sgn = -1;
                c = read();
            }
            int res = 0;
            while (c > ' ') {
                res = res * 10 + (c - '0');
                c = read();
            }
            return res * sgn;
        }
    }
}